/*dropa as views dependentes da pdv_vd*/

drop view if exists v_pdv_vd;
drop view if exists v_nfce_contingencia;
drop view if exists nada;
drop view if exists v_cupomfiscal;
drop view if exists v_cupomfiscal_cartao;
drop view if exists v_cupomfiscal_cheque;
drop view if exists v_cupomfiscal_crediario;
drop view if exists v_cupomfiscal_item;
drop view if exists v_cupomfiscal_pbm;
drop view if exists v_cupomfiscal_tef;
drop view if exists v_cupomfiscal_vale_compra;
drop view if exists v_meios_pgto_por_cupom;
drop view if exists v_meios_pgto_por_cupom_movimento_por_ecf_r07;
drop view if exists v_movimento_por_ecf_r04;
drop view if exists v_movimento_por_ecf_r05;
drop view if exists v_nfce;
drop view if exists v_nfce_env;
drop view if exists v_nfce_venda;
drop view if exists v_pdv_consld_vd;
drop view if exists v_pdv_consld_vd_nfce;
drop view if exists v_pdv_consld_vd_teste;
drop view if exists v_pdv_cupom_mapa_resumo_cx;
drop view if exists v_pdv_cupom_tef_transacao;
drop view if exists v_pdv_vd_chqs;
drop view if exists v_pdv_vd_cred;
drop view if exists v_pdv_vd_est_nf_ent;
drop view if exists v_pdv_vd_est_nf_sai;
drop view if exists v_pdv_vd_it;
drop view if exists v_pdv_vd_it_rec;
drop view if exists v_pdv_vd_orc;
drop view if exists v_pdv_vd_tef;
drop view if exists v_teste_pdv_vd;
drop view if exists v_teste_pdv_vd_nfce;

/*Executa alterações necessárias na pdv_vd*/

ALTER TABLE public.pdv_vd alter cd_nf type numeric(10,0);
ALTER TABLE public.pdv_vd alter nr_ecf type numeric(10,0);

/*Recria as views dependentes*/

CREATE OR REPLACE VIEW public.v_pdv_vd
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_cx,
    pdv_vd.cd_vd,
    pdv_vd.cd_cli,
    0 AS cd_adm_cartao,
    pdv_vd.vlr_vd,
    pdv_vd.vlr_liq_vd,
    pdv_vd.vlr_tot_prod,
    pdv_vd.vlr_desc,
    pdv_vd.vlr_desc_itens,
    pdv_vd.vlr_dinh,
    pdv_vd.vlr_chqs,
    pdv_vd.vlr_cartao,
    pdv_vd.vlr_tickets,
    pdv_vd.vlr_dup,
    pdv_vd.vlr_conv,
    pdv_vd.nr_ecf,
    pdv_vd.cd_nf,
    pdv_vd.dt_vd,
    pdv_vd.hr_vd,
    pdv_vd.st_vd,
    pdv_vd.cd_usu,
    pdv_vd.nr_orc,
    pdv_vd.vs_pdv,
    pdv_vd.vs_pdv_rc,
    pdv_vd.nsu_conv_ext,
    pdv_vd.vl_chqs_a_vista,
    pdv_vd.vl_chqs_a_prz,
    pdv_vd.orig_orc,
    pdv_vd.vlr_troco_chq,
    ''::character varying(10) AS nr_autorizacao,
    pdv_vd.nr_cartao_marka,
    pdv_vd.tipo,
    0 AS cod_bandeira,
    0 AS cod_rede,
    0 AS cod_modalidade,
    pdv_vd.alt_recbto,
    pdv_vd.cd_usu_cancel,
    0 AS vlr_saque_cartao,
    pdv_vd.st_canc_paf,
    COALESCE(pdv_vd.vd_troca_fidel, 0::numeric) AS vd_troca_fidel,
    COALESCE(pdv_vd.nr_ped_televd, 0::numeric) AS nr_ped_televd,
    COALESCE(pdv_vd.cd_conv, 0::numeric) AS cd_conv,
    pdv_vd.cgc_cpf,
    pdv_vd.end_cli,
    pdv_vd.resp_imp_dados_consumidor,
    COALESCE(pdv_vd.sts_orc_pend_televd, 0::numeric) AS sts_orc_pend_televd,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado,
    pdv_vd.nm_comprador,
    COALESCE(pdv_vd.qt_parc_conv, 0) AS qt_parc_conv,
    COALESCE(pdv_vd.vlr_ncc, 0::numeric) AS vlr_ncc,
    COALESCE(pdv_vd.perc_rec_conv, 0::numeric) AS perc_rec_conv,
    COALESCE(pdv_vd.tp_perc_rec_conv, 0) AS tp_perc_rec_conv,
    COALESCE(pdv_vd.dados_adicionais, ''::text) AS dados_adicionais,
    COALESCE(pdv_vd.cd_mov::double precision, 0::double precision) AS cd_mov,
    COALESCE(pdv_vd.vlr_recarga_cel, 0::numeric) AS vlr_recarga_cel,
    COALESCE(pdv_vd.nr_cel_recarga, ''::character varying) AS nr_cel_recarga,
    0 AS nr_oper_cel,
    COALESCE(pdv_vd.cd_cli_pbm, 0::numeric) AS cd_cli_pbm,
    pdv_vd.qtd_dias_prorrog,
    pdv_vd.nm_oper_cel,
    pdv_vd.vlr_conv_pbm,
    pdv_vd.envio_marka,
    pdv_vd.nr_autorizacao_marka,
    pdv_vd.tipo_pbm
   FROM pdv_vd
  WHERE pdv_vd.st_vd > '-1'::integer::numeric;
 
 -- public.v_nfce_contingencia source

CREATE OR REPLACE VIEW public.v_nfce_contingencia
AS SELECT env.cd_emp,
    env.cd_filial,
    serie.cd_cx,
    env.cd_nf,
    env.chv_nfce,
    env.aut_nfce,
    env.sts_pend,
    ''::text AS xml_nfce,
    env.cd_nf_serie,
    env.dt_cad,
    1 AS tp_contg,
    0 AS cd_vd,
    0 AS homolog_nfce,
    env.ds_motivo
   FROM pdv_cx_est_nf_serie serie
     JOIN est_nfce_env env ON serie.cd_emp = env.cd_emp::numeric AND serie.cd_filial = env.cd_filial::numeric AND serie.cd_nf_serie::text = env.cd_nf_serie::text
  WHERE env.sts_pend = 1 AND COALESCE(env.aut_nfce, ''::character varying)::text = ''::text AND date_part('month'::text, env.dt_cad) >= (to_char(now(), 'mm'::text)::smallint - 1)::double precision
UNION ALL
 SELECT env.cd_emp,
    env.cd_filial,
    serie.cd_cx,
    env.cd_nf,
    env.chv_nfce,
    env.aut_nfce,
    env.sts_pend,
    ''::text AS xml_nfce,
    env.cd_nf_serie,
    env.dt_cad,
    1 AS tp_contg,
    0 AS cd_vd,
    0 AS homolog_nfce,
    env.ds_motivo
   FROM pdv_cx_est_nf_serie serie
     JOIN est_nfce_env env ON serie.cd_emp = env.cd_emp::numeric AND serie.cd_filial = env.cd_filial::numeric AND serie.cd_nf_serie::text = env.cd_nf_serie::text
  WHERE env.sts_pend = 2 AND COALESCE(env.aut_nfce, ''::character varying)::text = ''::text AND to_char(env.dt_cad, 'YYYY-MM-DD HH24:MI:SS'::text) >= (to_char(now() - 1::double precision * '1 mon'::interval, 'yyyy-MM'::text) || '-01'::text) AND to_char(env.dt_cad, 'YYYY-MM-DD HH24:MI:SS'::text) <= ((now() - 1::double precision * '01:00:00'::interval)::text)
UNION ALL
 SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_cx,
    pdv_vd.cd_nf,
    pdv_vd.chv_nfce,
    ''::character varying AS aut_nfce,
    COALESCE(est_nfce_canc.sts_pend, 0) AS sts_pend,
    ''::text AS xml_nfce,
    pdv_vd.cd_nf_serie,
    pdv_vd.hr_vd AS dt_cad,
    2 AS tp_contg,
    pdv_vd.cd_vd,
    pdv_vd.homolog_nfce,
    ''::character varying AS ds_motivo
   FROM pdv_vd
     LEFT JOIN est_nfce_canc ON pdv_vd.cd_emp = est_nfce_canc.cd_emp::numeric AND pdv_vd.cd_filial = est_nfce_canc.cd_filial::numeric AND pdv_vd.cd_vd = est_nfce_canc.cd_vd
  WHERE (est_nfce_canc.sts_pend IS NULL OR (est_nfce_canc.sts_pend = ANY (ARRAY[1, 2]))) AND pdv_vd.st_vd = 1::numeric AND pdv_vd.tp_emis < 2::numeric AND COALESCE(est_nfce_canc.aut_canc, ''::character varying)::text = ''::text AND to_char(pdv_vd.hr_vd, 'YYYY-MM-DD HH24:MI:SS'::text) >= (to_char(now() - 1::double precision * '1 mon'::interval, 'yyyy-MM'::text) || '-01'::text) AND to_char(pdv_vd.hr_vd, 'YYYY-MM-DD HH24:MI:SS'::text) <= ((now() - 1::double precision * '01:00:00'::interval)::text);
 
 -- public.nada source

CREATE OR REPLACE VIEW public.nada
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.cd_cx,
    vd.nr_ecf,
    vd.vlr_liq_vd,
    ( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
           FROM pdv_vd_it it
          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
    ( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
           FROM pdv_vd_it it
          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
    0.00 AS naofiscal,
    0 AS tipovenda
   FROM pdv_vd vd
  WHERE vd.st_vd = 0::numeric
UNION ALL
 SELECT pdv_cupom_nao_fiscal.cd_emp,
    pdv_cupom_nao_fiscal.cd_filial,
    pdv_cupom_nao_fiscal.dt_cupom AS dt_vd,
    pdv_cupom_nao_fiscal.cd_cx,
    pdv_cupom_nao_fiscal.nr_coo AS nr_ecf,
    0 AS vlr_liq_vd,
    0 AS vndprod,
    0 AS vndserv,
    pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
    1 AS tipovenda
   FROM pdv_cupom_nao_fiscal
  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom <> 2::numeric;
 
 -- public.v_cupomfiscal source

CREATE OR REPLACE VIEW public.v_cupomfiscal
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.cd_cx,
    vd.dt_vd,
    COALESCE(vd.dt_cad, vd.dt_vd) AS dt_cad,
    COALESCE(vd.hr_vd, vd.dt_cad) AS hr_vd,
    vd.nr_orc,
    vd.nr_ped_televd,
    vd.orig_orc AS origem_orc,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    vd.cont_cupom_fisc AS contador_cupom_fiscal,
    vd.cd_mov AS codigo_movimento,
    NULL::character varying AS cgc_filial,
    NULL::character varying AS nm_filial,
    vd.cd_cli,
    vd.cgc_cpf AS cgc_cli,
    NULL::character varying AS nm_cli,
    vd.nr_cartao_marka AS numero_cartao,
    vd.cd_conv,
    NULL::integer AS cd_cli_conv,
    NULL::character varying AS cgc_conv,
    NULL::character varying AS nm_conv,
    COALESCE(vd.qtd_dias_prorrog, 0) AS dias_prorrog_conv,
    COALESCE(vd.tp_vd_api, 0) AS tp_vd_api,
    COALESCE(vd.nr_cartao_api, ''::character varying) AS nr_cartao_api,
    vd.vlr_liq_vd,
    vd.vlr_tot_prod,
    vd.vlr_vd,
    vd.vlr_desc,
    vd.vlr_desc_itens,
    vd.vlr_dinh,
    vd.vlr_troco,
        CASE
            WHEN vd.tipo_pbm > 0 AND COALESCE(vd.vlr_conv_pbm, 0::numeric) = 0::numeric AND vd.vlr_conv = 0::numeric THEN 0::numeric
            ELSE vd.vlr_conv
        END AS vlr_conv,
    vd.qt_parc_conv,
    vd.vlr_dup,
    vd.vl_chqs_a_vista AS valor_cheque_a_vista,
    vd.vl_chqs_a_prz AS valor_cheque_a_prazo,
    ncc.cd_ctr_ncc,
    ncc.vlr_ncc,
    vd.nr_cel_recarga,
    vd.vlr_recarga_cel,
    vd.nm_oper_cel,
    vd.nm_comprador,
    vd.dados_adicionais,
    vd.nr_serie_imp AS nr_serie_ecf,
    vd.vs_pdv AS versao_pdv,
    vd.vs_pdv_rc AS versao_pdv_rc,
    NULLIF(COALESCE(vd.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
        CASE
            WHEN vd.tipo_pbm > 0 AND COALESCE(vd.vlr_conv_pbm, 0::numeric) = 0::numeric AND vd.vlr_conv = 0::numeric THEN NULL::boolean
            ELSE true
        END AS contem_convenio,
    NULLIF(COALESCE(vd.vlr_dup, 0::numeric) <> 0::numeric, false) AS contem_duplicata,
    NULLIF(COALESCE(ncc.vlr_ncc, 0::numeric) <> 0::numeric, false) AS contem_ncc,
    NULLIF(COALESCE(vd.vlr_recarga_cel, 0::numeric) <> 0::numeric, false) AS contem_recarga_cel,
    vd.cd_usu AS cd_operador,
    ''::character varying AS nm_operador,
    vd.cd_usu_cancel,
    ''::character varying AS nm_usu_cancel,
    vd.cd_mt_cancel AS codigo_motivo_cancelamento,
    NULLIF(vd.st_vd <> 0::numeric, false) AS is_cancelado,
    vd.st_canc_paf = 1 AS is_cancelado_paf,
    COALESCE(vd.st_canc_paf, 0) AS st_canc_paf,
    COALESCE(audit.cd_outr_procd, 0::numeric) AS cd_outro_procedimento,
    COALESCE(audit.cd_usu, 0::numeric) AS cd_usu_procedimento,
    COALESCE(vd.cd_cli_pbm, 0::numeric(10,0)) AS cd_cli_pbm,
    COALESCE(vd.reg_alterado, 0) = 1 AS registroalterado,
    vd.vd_troca_fidel AS is_debitar_pontos,
    COALESCE(vd.vlr_imposto, 0::numeric) AS valor_ibpt,
    COALESCE(vd.tx_med_imposto, 0::numeric) AS percentual_ibpt,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado,
    vd.vlr_conv_pbm,
    vd.flag_nfce,
    nf_sai.cd_nf AS cd_nf_sai,
    nfce_cancel.cd_vd AS cancel_nfce,
    COALESCE(nfce_cancel.xml_canc, ''::character varying) AS xml_cancel,
    COALESCE(nfce_cancel.tp_canc, 0) AS tp_canc,
    COALESCE(nfce_cancel.chv_nfce, ''::character varying) AS chv_nfce_cancel,
    nfce_cancel.dt_emis AS dt_emis_cancel,
    COALESCE(nfce_cancel.aut_canc, ''::character varying) AS aut_canc,
    COALESCE(nfce_cancel.ds_motivo, ''::character varying) AS ds_motivo_cancel,
    COALESCE(vd.nr_cartao_marka, ''::character varying) AS nr_cartao_marka,
    COALESCE(vd.qtde_pontos_fidel_externo, 0::numeric) AS qtde_pontos_fidel_externo,
    COALESCE(vd.nr_tel_cupom, ''::character varying) AS nr_tel_cupom,
    COALESCE(vd.nr_mfe, 0) AS nr_mfe
   FROM pdv_vd vd
     LEFT JOIN pdv_vd_est_nf_sai nf_sai ON vd.cd_emp = nf_sai.cd_emp AND vd.cd_filial = nf_sai.cd_filial AND vd.cd_vd = nf_sai.cd_vd
     LEFT JOIN est_nfce_env e_nfce ON vd.cd_emp = e_nfce.cd_emp::numeric AND vd.cd_filial = e_nfce.cd_filial::numeric AND vd.nr_ecf = e_nfce.cd_nf::numeric AND vd.cd_nf_serie::text = e_nfce.cd_nf_serie::text
     LEFT JOIN pdv_vd_ncc ncc ON vd.cd_emp = ncc.cd_emp AND vd.cd_filial = ncc.cd_filial AND vd.cd_vd = ncc.cd_vd
     LEFT JOIN pdv_vd_glb_procd_outr_lib audit ON vd.cd_emp = audit.cd_emp AND vd.cd_filial = audit.cd_filial AND vd.cd_vd = audit.cd_vd AND (audit.cd_outr_procd = ANY (ARRAY[90::numeric, 91::numeric, 93::numeric, 94::numeric]))
     LEFT JOIN est_nfce_canc nfce_cancel ON vd.cd_emp = nfce_cancel.cd_emp::numeric AND vd.cd_filial = nfce_cancel.cd_filial::numeric AND vd.cd_vd = nfce_cancel.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric;
 
 -- public.v_cupomfiscal_cartao source

CREATE OR REPLACE VIEW public.v_cupomfiscal_cartao
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    COALESCE(vd.dt_cad, vd.dt_vd) AS dt_cad,
    COALESCE(vd.dt_cad, vd.hr_vd) AS hr_vd,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN tef.cd_adm_cartao
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.cd_adm_cartao
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::numeric
        END AS cd_conv,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN adm.nm_usual
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.nm_usual
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::character varying
        END AS nm_conv,
    tef.vl_cartao AS vlr_cartao,
    tef.vl_saque_cartao AS vlr_saque,
        CASE
            WHEN tef.qt_parc > 0 THEN tef.qt_parc::numeric
            ELSE adm.parc
        END AS qt_parc,
    tef.cod_rede,
    tef.cod_bandeira,
        CASE
            WHEN tef.cod_modalidade::text = ''::text THEN '0'::character varying
            ELSE tef.cod_modalidade
        END AS cod_modalidade,
    tef.tp_adm AS tp_administradora,
        CASE
            WHEN COALESCE(
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END, 0::numeric) > 0::numeric AND
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END <> 1::numeric THEN tef.nsu_tef
            WHEN
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END = 1::numeric THEN tef.cd_trn_tef
            WHEN COALESCE(
            CASE
                WHEN tef.nsu_tef = 0::numeric THEN NULL::numeric
                ELSE tef.nsu_tef
            END, 0::numeric) = 0::numeric THEN tef.cd_trn_tef
            ELSE NULL::numeric
        END AS nr_transacao,
        CASE
            WHEN COALESCE(tef.nr_autorizacao, '0'::character varying)::text > '0'::text AND tef.nr_autorizacao::text <> '1'::text THEN tef.nr_autorizacao
            WHEN tef.nr_autorizacao::text = '1'::text THEN tef.cd_trn_tef::character varying
            WHEN tef.nr_autorizacao::text = '0'::text THEN tef.cd_trn_tef::character varying
            ELSE NULL::character varying
        END AS nr_autorizacao,
    tef.ds_bandeira AS bandeira,
    COALESCE(tef.nr_estabelecimento, ''::character varying) AS nr_estabelecimento,
    COALESCE(tef.nr_comprovante, ''::character varying) AS nr_comprovante,
        CASE
            WHEN tef.gerenciador_tef = 1 THEN 'SCOPE'::character varying
            WHEN tef.trn_pos = 1 THEN 'POS'::character varying
            ELSE 'SITEF'::character varying
        END AS tef_gateway,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_tef tef ON vd.cd_emp = tef.cd_emp AND vd.cd_filial = tef.cd_filial AND vd.cd_vd = tef.cd_vd
     LEFT JOIN rc_adm_cartao adm ON tef.cd_emp = adm.cd_emp AND tef.cd_adm_cartao = adm.cd_adm_cartao
  WHERE tef.vl_cartao > 0::numeric AND (adm.tp_adm <> 6::numeric OR tef.cd_adm_cartao = 0::numeric);
 
 -- public.v_cupomfiscal_cheque source

CREATE OR REPLACE VIEW public.v_cupomfiscal_cheque
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.dt_cad,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    vd.vlr_troco_chq,
    chq.cd_bc_chq AS cd_bc,
    NULL::character varying AS nm_bc,
    chq.nr_ord,
    chq.nr_chq,
    chq.ano_chq,
    chq.vl_chq AS vlr_chq,
    chq.dt_emi,
    chq.dt_vencto,
    chq.ag_chq,
    ch_emi.cd_emi,
    chq.cpf_cgc_emi AS cgc_emi,
    chq.nm_emi,
    chq.fone_emi,
    chq.nr_cnt_chq,
    chq.aut_chq,
    chq.comp_chq,
    chq.c1_chq,
    chq.c2_chq,
    chq.sr_chq AS c3_chq,
    chq.cmc7_chq,
    chq.mes_ano_cnt_chq,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_chqs chq ON vd.cd_emp = chq.cd_emp AND vd.cd_filial = chq.cd_filial AND vd.cd_vd = chq.cd_vd
     LEFT JOIN chq_emi ch_emi ON chq.cpf_cgc_emi::text = ch_emi.cgc_cpf::text
  WHERE vd.st_vd > '-1'::integer::numeric;
 
 -- public.v_cupomfiscal_crediario source

CREATE OR REPLACE VIEW public.v_cupomfiscal_crediario
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.dt_cad,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    tef.cd_adm_cartao AS cd_conv,
    adm.nm_usual AS nm_conv,
    tef.vl_cartao AS vlr_cartao,
    tef.vl_saque_cartao AS vlr_saque,
    adm.parc AS qt_parc,
    tef.cod_rede,
    tef.cod_bandeira,
    tef.cod_modalidade,
    tef.nsu_tef AS nr_transacao,
    tef.nr_autorizacao,
        CASE
            WHEN tef.gerenciador_tef = 1 THEN 'scope'::text
            WHEN tef.trn_pos = 1 THEN 'pos'::text
            ELSE 'sitef'::text
        END AS tef_gateway,
    COALESCE(cred.cd_parc, 1::numeric) AS cd_parc,
    COALESCE(cred.dt_parc, vd.dt_vd) AS dt_parc,
    COALESCE(cred.vl_parc, tef.vl_cartao) AS vlr_parc,
        CASE
            WHEN COALESCE(cred.cd_parc, 0::numeric) = 0::numeric THEN 1
            ELSE 0
        END AS parc_mnt_pdv_erro,
    cred.cgc_cpf,
    cred.nr_fatura,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_tef tef ON vd.cd_emp = tef.cd_emp AND vd.cd_filial = tef.cd_filial AND vd.cd_vd = tef.cd_vd
     LEFT JOIN rc_adm_cartao adm ON tef.cd_emp = adm.cd_emp AND tef.cd_adm_cartao = adm.cd_adm_cartao
     LEFT JOIN pdv_vd_cred cred ON vd.cd_emp = cred.cd_emp AND vd.cd_filial = cred.cd_filial AND vd.cd_vd = cred.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND adm.tp_adm = 6::numeric AND vd.vlr_cartao > 0::numeric;
 
 -- public.v_cupomfiscal_item source

CREATE OR REPLACE VIEW v_cupomfiscal_item AS
	 SELECT vd.cd_emp,
		vd.cd_filial,
		vd.dt_vd,
		COALESCE(vd.dt_cad, vd.dt_vd) AS dt_cad,
		COALESCE(vd.dt_cad, vd.hr_vd) AS hr_vd,
		vd.cd_cx,
		vd.cd_vd,
		vd.nr_ecf,
		vd.st_vd,
		it.cd_it,
		it.cd_prod,
		est_orc_glb_medico.cd_medico_rec,
		NULL::character varying AS ds_prod,
		NULL::character varying AS cd_barra,
		it.qt_it,
		it.vlr_it,
		it.vlr_liq_it AS tot_it,
		it.st_it,
		it.tipo_desconto,
		COALESCE(it.tx_desc, (0)::numeric) AS tx_desc,
		COALESCE(it.vlr_desc_verba, (0)::numeric) AS vlr_desc_verba,
		COALESCE(it.vlr_desc_tot_rat, (0)::numeric) AS vlr_desc_rateio,
		it.cd_trib_fc,
		it.tx_icms_it,
		it.tx_red_it,
		it.cd_vend,
		NULL::character varying AS nm_vend,
		it.cd_vend_verba,
		NULL::character varying AS nm_vend_verba,
		it.cd_usu_cancel,
		NULL::character varying AS nm_usu_cancel,
		it.qtde_ponto_fidel AS qt_pontos_fidel,
		it.cd_grp_comis_pdv AS cd_grupo_comissao,
		(it.st_it <> (1)::numeric) AS is_cancelado,
		COALESCE(lote.cd_lote, (0)::numeric) AS cd_lote,
		0 AS numero_lote,
		COALESCE(lote.qtde_lote, (0)::numeric) AS qtde_prod_lote,
		(COALESCE(it.reg_alterado, 0) = 1) AS registroalteradoitem,
		COALESCE(it.tipo_imposto, (0)::numeric) AS tipo_imposto,
		it.vlr_imposto_it AS valor_ibpt_item,
		it.tx_imposto_it AS percentual_ibpt_item,
		it.nr_protocolo_manipulado,
		COALESCE(vd.flag_consolidado, 0) AS flag_consolidado,
		it.origem_produto,
		COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
		COALESCE(it.perc_fecop_st, 0.0) AS perc_fecop_st,
		COALESCE(it.perc_fecop_ret, 0.0) AS perc_fecop_ret,
		COALESCE(it.perc_icms, 0.0) AS perc_icms,
		COALESCE(it.perc_icms_subst, 0.0) AS perc_icms_subst,
		COALESCE(it.perc_red_base_calc, 0.0) AS perc_red_base_calc,
		Coalesce(it.motivo_desonerado_icms,0) as motivo_desonerado_icms,
		Coalesce(it.icms_desonerado, 0) as icms_desonerado,
		Coalesce(it.vlr_icms_desonerado_it, 0.0) as vlr_icms_desonerado_it,
		vd.regime_tributario,
		COALESCE(it.cfop, 0) as cfop,
		COALESCE(it.vlr_base_calc, 0.00) as vlr_base_calc,
		COALESCE(it.vlr_icms, 0.00) as vlr_icms,
		COALESCE(it.vlr_base_subst, 0.00) as vlr_base_subst,
		COALESCE(it.vlr_isento, 0.00) as vlr_isento,
		COALESCE(it.vlr_outras,  0.00) as vlr_outras,
		COALESCE(it.vlr_icms_subst,  0.00) as vlr_icms_subst,
		COALESCE(it.vlr_fecop,  0.00) as vlr_fecop,
		COALESCE(it.vlr_fecop_st,  0.00) as vlr_fecop_st,
		COALESCE(it.vlr_fecop_ret,  0.00)  as vlr_fecop_ret
	   FROM (((pdv_vd vd
		 JOIN pdv_vd_it it ON ((((it.cd_emp = vd.cd_emp) AND (it.cd_filial = vd.cd_filial)) AND (it.cd_vd = vd.cd_vd))))
		 LEFT JOIN pdv_vd_it_lote lote ON (((((it.cd_emp = lote.cd_emp) AND (it.cd_filial = lote.cd_filial)) AND (vd.cd_vd = lote.cd_vd)) AND (it.cd_it = lote.cd_it))))
		 LEFT JOIN est_orc_glb_medico ON (((((vd.cd_emp = (est_orc_glb_medico.cd_emp)::numeric) AND
		 (vd.cd_filial = (est_orc_glb_medico.cd_filial)::numeric)) AND (vd.nr_orc = (est_orc_glb_medico.nr_orc)::numeric)) AND
		 (it.cd_prod = (est_orc_glb_medico.cd_prod)::numeric)))
		 AND (it.cd_it = (est_orc_glb_medico.cd_it)::numeric))
	  WHERE ((vd.st_vd > ((-1))::numeric) AND (vd.nr_ecf > (0)::numeric));
 
 -- public.v_cupomfiscal_item_receita source

CREATE OR REPLACE VIEW public.v_cupomfiscal_item_receita
AS SELECT pdv_vd_it.cd_emp,
    pdv_vd_it.cd_filial,
    pdv_vd_it.cd_vd,
    pdv_vd_it.cd_it,
    COALESCE(pdv_vd_it.cd_medico_rec, vdit.cd_medico_rec::numeric) AS prescritor_id,
    COALESCE(pdv_vd_it.nr_receita, vdit.nr_receita::bigint) AS receita_numero,
        CASE
            WHEN date_part('day'::text, min(pdv_vd_it.dt_receita)) > 0::double precision THEN pdv_vd_it.dt_receita
            WHEN date_part('day'::text, min(vdit.dt_receita)) > 0::double precision THEN vdit.dt_receita
            ELSE 'now'::text::date::timestamp without time zone
        END AS receita_data,
        CASE
            WHEN pdv_vd_it.nm_comprador_receita::text <> ''::text THEN pdv_vd_it.nm_comprador_receita
            WHEN vdit.nm_comprador::text <> ''::text THEN vdit.nm_comprador
            ELSE ''::character varying
        END AS comprador_nome,
        CASE
            WHEN pdv_vd_it.nr_doc_cli_receita::text <> ''::text THEN pdv_vd_it.nr_doc_cli_receita
            WHEN vdit.nr_doc_cli::text <> ''::text THEN vdit.nr_doc_cli
            ELSE ''::character varying
        END AS comprador_doc_numero,
    COALESCE(pdv_vd_it.tp_doc_cli_receita, vdit.tipo_documento) AS comprador_doc_tipo,
    COALESCE(vdit.tp_doc_exp, 0) AS comprador_doc_expedidor,
        CASE
            WHEN pdv_vd_it.uf_receita::text <> ''::text THEN pdv_vd_it.uf_receita
            WHEN vdit.uf::text <> ''::text THEN vdit.uf
            ELSE ''::character varying
        END AS comprador_doc_uf,
    COALESCE(vdit.cid, 0) AS paciente_cid,
    COALESCE(pdv_vd_it.idade_receita, vdit.idade) AS paciente_idade,
        CASE
            WHEN pdv_vd_it.nm_paciente_receita::text <> ''::text THEN pdv_vd_it.nm_paciente_receita
            WHEN vdit.nm_paciente::text <> ''::text THEN vdit.nm_paciente
            ELSE ''::character varying
        END AS paciente_nome,
    COALESCE(vdit.sexo, 0) AS paciente_sexo,
    0 AS paciente_tipo_idade
   FROM pdv_vd_it
     JOIN pdv_vd vd ON vd.cd_emp = pdv_vd_it.cd_emp AND vd.cd_filial = pdv_vd_it.cd_filial AND vd.cd_vd = pdv_vd_it.cd_vd
     LEFT JOIN pdv_vd_it_rec vdit ON pdv_vd_it.cd_emp = vdit.cd_emp AND pdv_vd_it.cd_filial = vdit.cd_filial AND pdv_vd_it.cd_prod = vdit.cd_prod AND pdv_vd_it.cd_vd = vdit.cd_vd AND pdv_vd_it.cd_it = vdit.cd_it
  WHERE COALESCE(pdv_vd_it.cd_receita, vdit.cd_receita) > 0 AND vd.st_vd > '-1'::integer::numeric
  GROUP BY pdv_vd_it.cd_emp, pdv_vd_it.cd_filial, pdv_vd_it.cd_vd, pdv_vd_it.cd_it, vdit.cd_medico_rec, vdit.nr_receita, vdit.dt_receita, vdit.nm_comprador, vdit.nr_doc_cli, vdit.tipo_documento, vdit.tp_doc_exp, vdit.uf, vdit.cid, vdit.idade, vdit.nm_paciente, vdit.sexo
UNION
 SELECT orc.cd_emp,
    orc.cd_filial,
    vd.cd_vd,
    it.cd_it,
    COALESCE(orc.cd_medico_rec, 0) AS prescritor_id,
    COALESCE(orc.nr_receita, 0::bigint) AS receita_numero,
    COALESCE(orc.dt_receita, 'now'::text::date::timestamp without time zone) AS receita_data,
    COALESCE(orc.nm_comprador, NULL::character varying) AS comprador_nome,
    COALESCE(orc.nr_doc_cli, NULL::character varying) AS comprador_doc_numero,
    COALESCE(orc.tipo_documento, NULL::integer) AS comprador_doc_tipo,
    COALESCE(orc.tp_doc_exp, NULL::integer) AS comprador_doc_expedidor,
    COALESCE(orc.uf, NULL::character varying) AS comprador_doc_uf,
    NULL::integer AS paciente_cid,
    COALESCE(orc.idade, NULL::integer) AS paciente_idade,
    COALESCE(orc.nm_paciente, NULL::character varying) AS paciente_nome,
    COALESCE(orc.sexo, NULL::integer) AS paciente_sexo,
    0 AS paciente_tipo_idade
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
     JOIN est_orc_glb_medico orc ON it.cd_emp = orc.cd_emp::numeric AND it.cd_filial = orc.cd_filial::numeric AND vd.nr_orc = orc.nr_orc::numeric AND it.cd_prod = orc.cd_prod::numeric AND it.cd_it = orc.cd_it::numeric
  WHERE COALESCE(it.cd_receita, 0) = 0 AND vd.st_vd > '-1'::integer::numeric
  ORDER BY 1, 2, 3, 4;
 
 -- public.v_cupomfiscal_pbm source

CREATE OR REPLACE VIEW public.v_cupomfiscal_pbm
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.dt_cad,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    vd.cd_conv,
        CASE
            WHEN vd.tipo_pbm::numeric > 0::numeric THEN
            CASE
                WHEN vd.cd_cli_pbm = 0::numeric THEN ( SELECT rc_cli.cd_cli
                   FROM rc_cli
                  WHERE rc_cli.rot_conv_ext::numeric = vd.tipo_pbm::numeric AND rc_cli.sts_cli = 0::numeric
                 LIMIT 1)
                ELSE vd.cd_cli_pbm
            END
            ELSE vd.cd_cli
        END AS cd_cli_conv,
    NULL::character varying AS cgc_conv,
    vd.tipo_pbm,
        CASE vd.tipo_pbm
            WHEN 1 THEN 'prevsaude'::character varying
            WHEN 2 THEN 'vida-link'::character varying
            WHEN 3 THEN 'e-pharma'::character varying
            WHEN 4 THEN 'transaction center'::character varying
            WHEN 5 THEN 'farmacia popular'::character varying
            WHEN 6 THEN 'funcional card'::character varying
            ELSE 'outros'::character varying
        END AS nm_conv,
    vd.vlr_conv_pbm AS vlr_conv,
    COALESCE(it.nr_autorizacao_pbm, it.nr_orc_vd_link) AS cd_autorizacao,
    it.cd_it,
    it.cd_prod,
    it.vlr_avista_pbm AS vlr_prod_cli,
    COALESCE(
        CASE
            WHEN it.vlr_reembol_pbm = 0::numeric THEN NULL::numeric
            ELSE it.vlr_reembol_pbm
        END,
        CASE
            WHEN it.vlr_reembol = 0::numeric THEN NULL::numeric
            ELSE it.vlr_reembol
        END) AS vlr_prod_reembolso,
    it.vlr_conv_pbm AS vlr_prod_conv,
    COALESCE(it.cd_usu_libera_pos_pbm, 0::numeric) AS cd_usu_libera_pos_pbm,
    COALESCE(it.valor_desconto_pos_pbm, 0::numeric) AS valor_desconto_pos_pbm,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND vd.tipo_pbm > 0 AND (length(it.nr_autorizacao_pbm::text) > 1 OR length(it.nr_orc_vd_link::text) > 1);
 
 -- public.v_cupomfiscal_tef source

CREATE OR REPLACE VIEW public.v_cupomfiscal_tef
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN tef.cd_adm_cartao
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.cd_adm_cartao
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::numeric
        END AS cd_conv,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN adm.nm_usual
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.nm_usual
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::character varying
        END AS nm_conv,
        CASE adm.tp_adm
            WHEN 6 THEN 1
            ELSE 0
        END AS tp_cartao,
    tef.vl_cartao AS vlr_cartao,
    tef.vl_saque_cartao AS vlr_saque,
        CASE adm.tp_adm
            WHEN 6 THEN adm.parc
            ELSE tef.qt_parc::numeric
        END AS qt_parc,
    tef.cod_rede,
    tef.cod_bandeira,
    tef.cod_modalidade,
        CASE
            WHEN COALESCE(tef.nsu_tef, 0::numeric) > 0::numeric AND tef.nsu_tef <> 1::numeric THEN tef.nsu_tef
            WHEN tef.nsu_tef = 1::numeric THEN tef.cd_trn_tef
            WHEN COALESCE(tef.nsu_tef, 0::numeric) = 0::numeric THEN tef.cd_trn_tef
            ELSE NULL::numeric
        END AS nr_transacao,
        CASE
            WHEN COALESCE(tef.nr_autorizacao, '0'::character varying)::text > '0'::text AND tef.nr_autorizacao::text <> '1'::text THEN tef.nr_autorizacao
            WHEN tef.nr_autorizacao::text = '1'::text THEN tef.cd_trn_tef::character varying
            WHEN tef.nr_autorizacao::text = '0'::text THEN tef.cd_trn_tef::character varying
            ELSE NULL::character varying
        END AS nr_autorizacao,
        CASE
            WHEN tef.gerenciador_tef = 1 THEN 'scope'::text
            WHEN tef.trn_pos = 1 THEN 'pos'::text
            ELSE 'sitef'::text
        END AS tef_gateway,
    cred.cd_parc,
    cred.dt_parc,
    cred.vl_parc AS vlr_parc,
    vd.flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_tef tef ON vd.cd_emp = tef.cd_emp AND vd.cd_filial = tef.cd_filial AND vd.cd_vd = tef.cd_vd
     LEFT JOIN rc_adm_cartao adm ON tef.cd_emp = adm.cd_emp AND tef.cd_adm_cartao = adm.cd_adm_cartao
     LEFT JOIN pdv_vd_cred cred ON vd.cd_emp = cred.cd_emp AND vd.cd_filial = cred.cd_filial AND vd.cd_vd = cred.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND COALESCE(vd.vlr_cartao, 0::numeric) <> 0::numeric;
 
 -- public.v_cupomfiscal_vale_compra source

CREATE OR REPLACE VIEW public.v_cupomfiscal_vale_compra
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_cx,
    pdv_vd.cd_vd,
    pdv_vd.nr_ecf,
    pdv_vd.st_vd,
    pdv_vd.dt_vd,
    pdv_vd.vlr_tickets,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado,
    pdv_vd_rc_cli_fideli_vale_compra.cd_ctr_vale_cp,
    pdv_vd_rc_cli_fideli_vale_compra.vlr_vale_cp
   FROM pdv_vd
     JOIN pdv_vd_rc_cli_fideli_vale_compra ON pdv_vd.cd_emp = pdv_vd_rc_cli_fideli_vale_compra.cd_emp AND pdv_vd.cd_filial = pdv_vd_rc_cli_fideli_vale_compra.cd_filial AND pdv_vd.cd_vd = pdv_vd_rc_cli_fideli_vale_compra.cd_vd
  WHERE pdv_vd.st_vd > '-1'::integer::numeric;
 
 -- public.v_meios_pgto_por_cupom source

CREATE OR REPLACE VIEW public.v_meios_pgto_por_cupom
AS SELECT rstemp.cd_emp,
    rstemp.cd_filial,
    rstemp.dt_vd,
    rstemp.nr_coo,
    rstemp.cont_cupom_fisc,
    rstemp.nr_cont_geral_nao_fiscal,
    rstemp.id_documento,
    rstemp.ds_meio_pgto,
    rstemp.cod_bandeira,
    rstemp.cod_modalidade,
    rstemp.cd_adm_cartao,
    rstemp.vlr_pag
   FROM ( SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
                CASE
                    WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '01'::text THEN 'CARTAO DEBITO'::text
                    ELSE
                    CASE
                        WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '02'::text THEN 'CARTAO CREDITO'::text
                        ELSE 'CARTAO'::text
                    END
                END AS ds_meio_pgto,
            pdv_vd_tef.vl_cartao AS vlr_pag,
            pdv_vd_tef.cod_bandeira,
            pdv_vd_tef.cod_modalidade,
            pdv_vd_tef.cd_adm_cartao
           FROM pdv_vd
             JOIN pdv_vd_tef ON pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd
          WHERE pdv_vd.vlr_cartao > 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'CHEQUES'::text AS ds_meio_pgto,
            pdv_vd.vlr_chqs AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao
           FROM pdv_vd
          WHERE pdv_vd.vlr_chqs > 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'CONVENIO'::text AS ds_meio_pgto,
            pdv_vd.vlr_conv AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao
           FROM pdv_vd
          WHERE pdv_vd.vlr_conv > 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'Dinheiro'::text AS ds_meio_pgto,
            pdv_vd.vlr_dinh AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao
           FROM pdv_vd
          WHERE pdv_vd.vlr_dinh > 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'CREDIARIO'::text AS ds_meio_pgto,
            pdv_vd.vlr_dup AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao
           FROM pdv_vd
          WHERE pdv_vd.vlr_dup > 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'TICKETS'::text AS ds_meio_pgto,
            pdv_vd.vlr_tickets AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao
           FROM pdv_vd
          WHERE pdv_vd.vlr_tickets > 0::numeric
        UNION ALL
         SELECT rec_n_fisc.cd_emp,
            rec_n_fisc.cd_filial,
            rec_n_fisc.cd_ctr AS cd_vd,
            rec_n_fisc.dt_cupom AS dt_vd,
            rec_n_fisc.nr_coo,
            rec_n_fisc.cont_cupom_fisc,
            rec_n_fisc.cont_geral_n_fisc AS nr_cont_geral_nao_fiscal,
            'CNF'::text AS id_documento,
            pgtos.ds_meio_pgto,
            pgtos.vlr_forma_pagto AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao
           FROM pdv_cupom_nao_fiscal rec_n_fisc
             JOIN v_pdv_cupom_nao_fiscal_forma_pgtos pgtos ON rec_n_fisc.cd_ctr = pgtos.cd_ctr) rstemp
  ORDER BY rstemp.dt_vd, rstemp.ds_meio_pgto;
 
 -- public.v_meios_pgto_por_cupom_movimento_por_ecf_r07 source

CREATE OR REPLACE VIEW public.v_meios_pgto_por_cupom_movimento_por_ecf_r07
AS SELECT rstemp.cd_emp,
    rstemp.cd_filial,
    rstemp.cd_cx,
    rstemp.dt_vd,
    rstemp.nr_coo,
    rstemp.cont_cupom_fisc,
    rstemp.nr_cont_geral_nao_fiscal,
    rstemp.id_documento,
    rstemp.ds_meio_pgto,
    rstemp.cod_bandeira,
    rstemp.cod_modalidade,
    rstemp.cd_adm_cartao,
    rstemp.vlr_pag,
    ( SELECT pdv_cx.modelo_ecf
           FROM pdv_cx
          WHERE rstemp.cd_emp = pdv_cx.cd_emp AND rstemp.cd_filial = pdv_cx.cd_filial AND rstemp.cd_cx = pdv_cx.cd_cx) AS modelo_ecf,
        CASE
            WHEN COALESCE(rstemp.reg_alterado::boolean, false) = true THEN 1
            ELSE 0
        END AS reg_alterado,
    rstemp.nr_serie_imp
   FROM ( SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
                CASE
                    WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '01'::text THEN 'CARTAO DEBITO'::text
                    ELSE
                    CASE
                        WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '02'::text THEN 'CARTAO CREDITO'::text
                        ELSE 'CARTAO'::text
                    END
                END AS ds_meio_pgto,
            pdv_vd_tef.vl_cartao AS vlr_pag,
            pdv_vd_tef.cod_bandeira,
            pdv_vd_tef.cod_modalidade,
            pdv_vd_tef.cd_adm_cartao,
            pdv_vd.reg_alterado,
            pdv_vd.nr_serie_imp
           FROM pdv_vd
             JOIN pdv_vd_tef ON pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd
          WHERE pdv_vd.vlr_cartao > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'CHEQUES'::text AS ds_meio_pgto,
            pdv_vd.vlr_chqs AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao,
            pdv_vd.reg_alterado,
            pdv_vd.nr_serie_imp
           FROM pdv_vd
          WHERE pdv_vd.vlr_chqs > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'CONVENIO'::text AS ds_meio_pgto,
            pdv_vd.vlr_conv AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao,
            pdv_vd.reg_alterado,
            pdv_vd.nr_serie_imp
           FROM pdv_vd
          WHERE pdv_vd.vlr_conv > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'Dinheiro'::text AS ds_meio_pgto,
            pdv_vd.vlr_dinh AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao,
            pdv_vd.reg_alterado,
            pdv_vd.nr_serie_imp
           FROM pdv_vd
          WHERE pdv_vd.vlr_dinh > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'CREDIARIO'::text AS ds_meio_pgto,
            pdv_vd.vlr_dup AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao,
            pdv_vd.reg_alterado,
            pdv_vd.nr_serie_imp
           FROM pdv_vd
          WHERE pdv_vd.vlr_dup > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.dt_vd,
            pdv_vd.nr_ecf AS nr_coo,
            pdv_vd.cont_cupom_fisc,
            0 AS nr_cont_geral_nao_fiscal,
            'CF'::text AS id_documento,
            'TICKETS'::text AS ds_meio_pgto,
            pdv_vd.vlr_tickets AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao,
            pdv_vd.reg_alterado,
            pdv_vd.nr_serie_imp
           FROM pdv_vd
          WHERE pdv_vd.vlr_tickets > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT rec_n_fisc.cd_emp,
            rec_n_fisc.cd_filial,
            rec_n_fisc.cd_cx,
            rec_n_fisc.cd_ctr AS cd_vd,
            COALESCE(doc.dt_final_emis, rec_n_fisc.dt_cupom) AS dt_vd,
            rec_n_fisc.nr_coo,
            rec_n_fisc.cont_cupom_fisc,
            rec_n_fisc.cont_geral_n_fisc AS nr_cont_geral_nao_fiscal,
            'CNF'::text AS id_documento,
            pgtos.ds_meio_pgto,
            pgtos.vlr_forma_pagto AS vlr_pag,
            0 AS cod_bandeira,
            ''::character varying AS cod_modalidade,
            0 AS cd_adm_cartao,
            rec_n_fisc.reg_alterado,
            rec_n_fisc.nr_serie_imp
           FROM pdv_cupom_nao_fiscal rec_n_fisc
             JOIN v_pdv_cupom_nao_fiscal_forma_pgtos pgtos ON rec_n_fisc.cd_cx = pgtos.cd_cx AND rec_n_fisc.cd_ctr = pgtos.cd_ctr
             LEFT JOIN pdv_outros_documentos doc ON rec_n_fisc.cd_emp = doc.cd_emp AND rec_n_fisc.cd_filial = doc.cd_filial AND rec_n_fisc.cd_cx = doc.cd_cx AND rec_n_fisc.nr_coo = doc.cont_ordem_operacao) rstemp
  ORDER BY rstemp.dt_vd, rstemp.ds_meio_pgto;
 
 -- public.v_nfce source

CREATE OR REPLACE VIEW public.v_nfce
AS SELECT cp.cd_emp,
    cp.cd_filial,
    cp.cd_cx,
    cp.cd_vd,
    cp.dt_vd,
    cp.nr_ecf,
    cp.cd_cli,
    cp.cgc_cpf,
    cp.nm_cli,
    cp.vlr_desc,
    cp.vlr_dinh,
    cp.vlr_chqs,
    cp.vlr_troco,
    cp.vlr_cartoes_linx,
    it.cd_benef,
    ( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_transacao <> 2::numeric AND item.tp_adm <> 6) AS vlr_cartao,
    ( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
           FROM pdv_vd_cred item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vlr_crediario,
    cp.vlr_tickets,
    cp.vlr_conv,
    cp.vlr_dup,
    cp.vlr_ncc,
    cp.st_vd,
    cp.vlr_conv_pbm,
    ( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) AS "coalesce"
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_it,
    ( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) - cp.vlr_desc
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_vd,
    ( SELECT COALESCE(sum(item.vlr_tot_it), 0::numeric) AS "coalesce"
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_bruto_it,
    it.cd_it,
    it.cd_barras AS ean,
    it.cd_prod,
        CASE
            WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN p.ds_usual
            ELSE it.ds_prod_vd
        END AS ds_prod,
    p.ncm_prod,
    p.vlr_pmc,
    p.ctr_pmc,
    0 AS ean_trib,
    medidas.ds_un AS cd_un_vd,
    it.qt_it,
    it.vlr_it,
    it.vlr_tot_it,
    it.vlr_desc_it,
    it.vlr_liq_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.tx_red_it,
    it.st_it,
    it.tipo_imposto,
    it.cd_vend,
    cp.cd_nf_serie,
    cp.cd_usu,
    cp.vlr_imposto,
    cp.vlr_imposto_uf,
    cp.vlr_imposto_mun,
    it.vlr_desc_tot_rat,
    it.nr_cest,
    COALESCE(p.nr_serv, ''::character varying) AS nr_serv,
    cp.hr_vd,
    cp.tipo_pbm,
    cp.tp_emis,
    pdv_cx.cod_ativacao_mfe,
    pdv_cx.signacmfe,
    COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
    COALESCE(it.perc_fecop_st, 0.0) AS perc_fecop_st,
    COALESCE(it.perc_fecop_ret, 0.0) AS perc_fecop_ret,
    COALESCE(it.perc_icms, 0.0) AS perc_icms,
    COALESCE(it.perc_icms_subst, 0.0) AS perc_icms_subst,
    COALESCE(it.perc_red_base_calc, 0.0) AS perc_red_base_calc,
    COALESCE(it.perc_red_base_calc_efet, 0.0) AS perc_red_base_calc_efet,
    COALESCE(it.perc_icms_efet, 0.0) AS perc_icms_efet,
    COALESCE(it.perc_st, 0.0) AS perc_st,
    COALESCE(it.perc_icms_ret, 0.0) AS perc_icms_ret,
    COALESCE(it.motivo_desonerado_icms, 0::numeric) AS motivo_desonerado_icms,
    COALESCE(it.icms_desonerado, 0::numeric) AS icms_desonerado,
    COALESCE(it.vlr_icms_desonerado_it, 0.0) AS vlr_icms_desonerado_it,
    cp.regime_tributario,
    it.origem_produto,
    it.cfop,
    it.vlr_base_calc,
    it.vlr_base_calc_pis,
    it.vlr_base_calc_cofins,
    it.vlr_icms,
    it.vlr_base_subst,
    it.vlr_isento,
    it.vlr_outras,
    it.vlr_icms_subst,
    it.vlr_fecop,
    it.vlr_fecop_st,
    it.vlr_fecop_ret,
    it.vlr_base_calc_efet,
    it.vlr_icms_efet,
    it.vlr_base_calc_ret,
    it.vlr_icms_ret,
    it.vlr_frete_rat,
    cp.vlr_frete_tot,
    pvo.tp_orc_entg
   FROM pdv_vd cp
     JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
     JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
     JOIN pdv_cx ON cp.cd_emp = pdv_cx.cd_emp AND cp.cd_filial = pdv_cx.cd_filial AND cp.cd_cx = pdv_cx.cd_cx
     LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un
     LEFT JOIN pdv_vd_orc pvo ON pvo.cd_emp = cp.cd_emp AND pvo.cd_filial = cp.cd_filial AND pvo.cd_vd = cp.cd_vd;


-- public.v_nfce_env source

CREATE OR REPLACE VIEW public.v_nfce_env
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.cd_cx,
    vd.cd_vd,
    vd.dt_vd,
    vd.nr_ecf,
    vd.cd_cli,
    vd.cgc_cpf,
    vd.nm_cli,
    vd.vlr_desc,
    vd.vlr_dinh,
    vd.vlr_chqs,
    vd.partner_promotion_id,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS vl_cartao
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6) AS vlr_cartao,
    ( SELECT COALESCE(sum(cred.vl_parc), 0::numeric) AS vl_crediario
           FROM pdv_vd_cred cred
          WHERE cred.cd_emp = vd.cd_emp AND cred.cd_filial = vd.cd_filial AND cred.cd_vd = vd.cd_vd) AS vlr_crediario,
    vd.vlr_tickets,
    vd.vlr_conv,
    vd.vlr_dup,
    vd.vlr_ncc,
    vd.st_vd,
    vd.vlr_conv_pbm,
    ( SELECT COALESCE(sum(it_1.vlr_liq_it), 0::numeric) AS vlr_liq_it
           FROM pdv_vd_it it_1
          WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_liq_it,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND ("substring"(tef.cod_modalidade::text, 1, 2) = '01'::text OR "substring"(tef.cod_modalidade::text, 1, 2) = '03'::text) AND tef.trn_pos <> 4) AS vlr_cartao_debito,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND "substring"(tef.cod_modalidade::text, 1, 2) = '02'::text AND tef.trn_pos <> 4) AS vlr_cartao_credito,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND tef.trn_pos = 4) AS vlr_qr_linx,
    ( SELECT COALESCE(sum(it_1.vlr_liq_it), 0::numeric) - vd.vlr_desc
           FROM pdv_vd_it it_1
          WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_liq_vd,
    ( SELECT COALESCE(sum(it_1.vlr_tot_it), 0::numeric) AS vlr_tot_it
           FROM pdv_vd_it it_1
          WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_bruto_it,
    it.cd_it,
    it.cd_barras AS ean,
    it.cd_prod,
        CASE
            WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN prod.ds_usual
            ELSE it.ds_prod_vd
        END AS ds_prod,
    prod.ncm_prod,
    med.ds_un AS cd_un_vd,
    it.qt_it,
    it.vlr_it,
    it.vlr_tot_it,
    it.vlr_desc_it,
    it.vlr_liq_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.tx_red_it,
    it.st_it,
    it.tipo_imposto,
    it.cd_vend,
    it.vlr_desc_tot_rat,
    vd.cd_nf_serie,
    vd.cd_usu,
    vd.vlr_imposto,
    vd.vlr_imposto_uf,
    vd.vlr_imposto_mun,
    vd.inf_cpl_nfce,
    vd.homolog_nfce,
    vd.url_danfe_nfce,
    nfce.chv_nfce,
    nfce.aut_nfce,
    nfce.sts_pend,
    nfce.ds_motivo,
    nfce.dt_cad AS dt_emi,
    vd.vlr_troco,
    nfce.xml_nfce,
    e.cod_ativacao_mfe,
    e.signacmfe,
    vd.end_cli,
    it.cd_prod_kit,
    it.nr_cest,
    it.vlr_frete_rat,
    vd.vlr_frete_tot,
    vd.nr_mfe
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
     JOIN est_nfce_env nfce ON vd.cd_emp = nfce.cd_emp::numeric AND vd.cd_filial = nfce.cd_filial::numeric AND vd.cd_nf_serie::text = nfce.cd_nf_serie::text AND vd.nr_ecf = nfce.cd_nf::numeric
     JOIN est_prod prod ON it.cd_emp = prod.cd_emp AND it.cd_prod = prod.cd_prod
     LEFT JOIN est_prod_un_med med ON prod.cd_emp = med.cd_emp AND prod.cd_un_vd = med.cd_ctr_un
     JOIN pdv_cx e ON e.cd_emp = vd.cd_emp AND e.cd_cx = vd.cd_cx AND e.cd_filial = vd.cd_filial;


-- public.v_nfce_venda source

CREATE OR REPLACE VIEW public.v_nfce_venda
AS SELECT cp.cd_emp,
    cp.cd_filial,
    cp.cd_cx,
    cp.cd_vd,
    cp.dt_vd AS dt_cupom,
    cp.nr_ecf,
    cp.cd_cli,
    cp.cgc_cpf,
    cp.nm_cli,
    cp.vlr_desc AS vl_desc_vd,
    cp.vlr_dinh AS vl_dinh,
    cp.vlr_chqs AS vl_chqs,
    ( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vl_cartao,
    ( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
           FROM pdv_vd_cred item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vl_crediario,
    cp.vlr_tickets AS vl_tickets,
    cp.vlr_conv AS vl_conv,
    cp.vlr_dup AS vl_dup,
    cp.vlr_ncc,
    cp.st_vd AS st_cupom,
    cp.vlr_conv_pbm,
    cp.vlr_tot_prod AS vl_to_liq_it,
    cp.vlr_liq_vd AS vl_to_liq_vd,
    cp.vlr_vd AS vl_to_bruto_it,
    it.cd_it,
    COALESCE(it.cd_barras, '0'::character varying)::text AS ean,
    it.cd_prod,
    p.ds_prod,
    p.ncm_prod,
    0 AS ean_trib,
    medidas.ds_un AS cd_un_vd,
    it.qt_it,
    it.vlr_it AS vl_unit,
    it.qt_it * it.vlr_it AS vl_to_it,
    it.qt_it * it.vlr_it - it.vlr_tot_it AS vl_desc_it,
    it.vlr_tot_it AS vl_liq_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.tx_red_it,
    it.st_it AS sts_prod,
    it.tipo_imposto,
    cp.cd_nf_serie,
    cp.vlr_imposto,
    cp.tx_med_imposto
   FROM pdv_vd cp
     JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
     JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
     LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un;


-- public.v_pdv_consld_vd source

CREATE OR REPLACE VIEW public.v_pdv_consld_vd
AS SELECT venda.cd_emp,
    venda.cd_filial,
    venda.dt_vd,
    venda.cd_cx,
    sum(venda.nr_coo_ini) AS nr_coo_ini,
    sum(venda.nr_coo_fin) AS nr_coo_fin,
    sum(venda.vl_vd_prod) AS vl_vd_prod,
    sum(venda.vl_vd_serv) AS vl_vd_serv,
    sum(venda.vl_vd_nfiscal) AS vl_vd_nfiscal
   FROM ( SELECT consolid.cd_emp,
            consolid.cd_filial,
            consolid.dt_vd,
            consolid.cd_cx,
            ( SELECT COALESCE(min(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_ini,
            ( SELECT COALESCE(max(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_fin,
            sum(consolid.vndprod) AS vl_vd_prod,
            sum(consolid.vndserv) AS vl_vd_serv,
            sum(consolid.naofiscal) AS vl_vd_nfiscal
           FROM ( SELECT vd.cd_emp,
                    vd.cd_filial,
                    vd.dt_vd,
                    vd.cd_cx,
                    vd.nr_ecf,
                    vd.vlr_liq_vd,
                    ( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
                    ( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
                    0.00 AS naofiscal,
                    0 AS tipovenda
                   FROM pdv_vd vd
                  WHERE vd.st_vd = 0::numeric
                UNION ALL
                 SELECT pdv_cupom_nao_fiscal.cd_emp,
                    pdv_cupom_nao_fiscal.cd_filial,
                    pdv_cupom_nao_fiscal.dt_cupom,
                    pdv_cupom_nao_fiscal.cd_cx,
                    pdv_cupom_nao_fiscal.nr_coo,
                    0 AS vlr_liq_vd,
                    0 AS vndprod,
                    0 AS vndserv,
                    pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
                    1 AS tipovenda
                   FROM pdv_cupom_nao_fiscal
                  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom <> 2::numeric) consolid
          GROUP BY consolid.cd_emp, consolid.cd_filial, consolid.dt_vd, consolid.cd_cx, consolid.tipovenda) venda
  GROUP BY venda.cd_emp, venda.cd_filial, venda.dt_vd, venda.cd_cx;


-- public.v_pdv_consld_vd_nfce source

CREATE OR REPLACE VIEW public.v_pdv_consld_vd_nfce
AS SELECT venda.cd_emp,
    venda.cd_filial,
    venda.dt_vd,
    venda.cd_cx,
    sum(venda.nr_coo_ini) AS nr_coo_ini,
    sum(venda.nr_coo_fin) AS nr_coo_fin,
    sum(venda.vl_vd_prod) AS vl_vd_prod,
    sum(venda.vl_vd_serv) AS vl_vd_serv,
    sum(venda.vl_vd_nfiscal) AS vl_vd_nfiscal
   FROM ( SELECT consolid.cd_emp,
            consolid.cd_filial,
            consolid.dt_vd,
            consolid.cd_cx,
            ( SELECT COALESCE(min(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_ini,
            ( SELECT COALESCE(max(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_fin,
            sum(consolid.vndprod) AS vl_vd_prod,
            sum(consolid.vndserv) AS vl_vd_serv,
            sum(consolid.naofiscal) AS vl_vd_nfiscal
           FROM ( SELECT vd.cd_emp,
                    vd.cd_filial,
                    vd.dt_vd,
                    vd.cd_cx,
                    vd.nr_ecf,
                    vd.vlr_liq_vd,
                    ( SELECT COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
                    ( SELECT COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
                    0.00 AS naofiscal,
                    0 AS tipovenda
                   FROM pdv_vd vd
                  WHERE vd.st_vd = 0::numeric
                UNION ALL
                 SELECT pdv_cupom_nao_fiscal.cd_emp,
                    pdv_cupom_nao_fiscal.cd_filial,
                    pdv_cupom_nao_fiscal.dt_cupom,
                    pdv_cupom_nao_fiscal.cd_cx,
                    pdv_cupom_nao_fiscal.nr_coo,
                    0 AS vlr_liq_vd,
                    0 AS vndprod,
                    0 AS vndserv,
                    pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
                    1 AS tipovenda
                   FROM pdv_cupom_nao_fiscal
                  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom = 1::numeric) consolid
          GROUP BY consolid.cd_emp, consolid.cd_filial, consolid.dt_vd, consolid.cd_cx, consolid.tipovenda) venda
  GROUP BY venda.cd_emp, venda.cd_filial, venda.dt_vd, venda.cd_cx;


-- public.v_pdv_consld_vd_teste source

CREATE OR REPLACE VIEW public.v_pdv_consld_vd_teste
AS SELECT venda.cd_emp,
    venda.cd_filial,
    venda.dt_vd,
    venda.cd_cx,
    sum(venda.nr_coo_ini) AS nr_coo_ini,
    sum(venda.nr_coo_fin) AS nr_coo_fin,
    sum(venda.vl_vd_prod) AS vl_vd_prod,
    sum(venda.vl_vd_serv) AS vl_vd_serv,
    sum(venda.vl_vd_nfiscal) AS vl_vd_nfiscal
   FROM ( SELECT consolid.cd_emp,
            consolid.cd_filial,
            consolid.dt_vd,
            consolid.cd_cx,
            ( SELECT COALESCE(min(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_ini,
            ( SELECT COALESCE(max(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_fin,
            sum(consolid.vndprod) AS vl_vd_prod,
            sum(consolid.vndserv) AS vl_vd_serv,
            sum(consolid.naofiscal) AS vl_vd_nfiscal
           FROM ( SELECT vd.cd_emp,
                    vd.cd_filial,
                    vd.dt_vd,
                    vd.cd_cx,
                    vd.nr_ecf,
                    vd.vlr_liq_vd,
                    ( SELECT COALESCE(sum(it.tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
                    ( SELECT COALESCE(sum(it.tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
                    0.00 AS naofiscal,
                    0 AS tipovenda
                   FROM pdv_vd vd
                  WHERE vd.st_vd = 0::numeric
                UNION ALL
                 SELECT pdv_cupom_nao_fiscal.cd_emp,
                    pdv_cupom_nao_fiscal.cd_filial,
                    pdv_cupom_nao_fiscal.dt_cupom,
                    pdv_cupom_nao_fiscal.cd_cx,
                    pdv_cupom_nao_fiscal.nr_coo,
                    0 AS vlr_liq_vd,
                    0 AS vndprod,
                    0 AS vndserv,
                    pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
                    1 AS tipovenda
                   FROM pdv_cupom_nao_fiscal
                  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom <> 2::numeric) consolid
          GROUP BY consolid.cd_emp, consolid.cd_filial, consolid.dt_vd, consolid.cd_cx, consolid.tipovenda) venda
  GROUP BY venda.cd_emp, venda.cd_filial, venda.dt_vd, venda.cd_cx;


-- public.v_pdv_cupom_mapa_resumo_cx source

CREATE OR REPLACE VIEW public.v_pdv_cupom_mapa_resumo_cx AS 
 SELECT 
    temp.cd_emp,
    temp.cd_filial,
    temp.cd_cx,
    temp.dt_cupom AS dt_mov,
    COALESCE(pos_ecf.cont_reducao_z, 0::numeric) AS cont_reducao_z,
    COALESCE(pos_ecf.cont_reinicio_op, 0::numeric) AS cont_reinicio_op,
    COALESCE(pos_ecf.vl_gt_ini, 0::numeric) AS vlr_gt_ini,
    COALESCE(pos_ecf.vl_gt_fin, 0::numeric) AS vlr_gt_fin,
    min(temp.coo) - 1::numeric AS coo_inicial,
    max(temp.coo) + 1::numeric AS coo_final,
    COALESCE(sum(temp.vlr_contab), 0::numeric) AS vlr_contab,
    COALESCE(sum(temp.vlr_it_cancel), 0::numeric) AS vlr_it_cancel,
    COALESCE(sum(temp.vlr_cupons_cancelados), 0::numeric) AS vlr_cupons_cancelados,
    COALESCE(sum(temp.vlr_cupons_cancelados), 0::numeric) + COALESCE(sum(temp.vlr_it_cancel), 0::numeric) AS vlr_cancelamentos,
    COALESCE(sum(temp.vlr_cupons_cancelados_issqn), 0::numeric) + COALESCE(sum(temp.vlr_it_cancel_issqn), 0::numeric) AS vlr_cancelamentos_issqn,
    COALESCE(sum(temp.vlr_desc_it), 0::numeric) AS vlr_desc_it,
    COALESCE(sum(temp.vlr_desc_it_issqn), 0::numeric) AS vlr_desc_issqn,
    COALESCE(sum(temp.vl_desc_vd), 0::numeric) AS vlr_desc_vd,
    COALESCE(sum(temp.vlr_desc_it), 0::numeric) + COALESCE(sum(temp.vl_desc_vd), 0::numeric) AS vlr_descontos,
    COALESCE(sum(temp.vlr_vd_liq), 0::numeric) AS vlr_vd_liq,
    COALESCE(trib.vlr_subst_trib, 0::numeric) AS vlr_subst_trib,
    COALESCE(trib.vlr_isentas, 0::numeric) AS vlr_isentas,
    COALESCE(trib.vlr_n_incidencia, 0::numeric) AS vlr_n_incidencia,
    COALESCE(trib.vlr_base_calc_icms, 0::numeric) AS vlr_base_calc_icms,
    COALESCE(trib.vlr_imposto::double precision, 0::double precision) AS vlr_imposto,
    COALESCE(trib_taxas.tx_icms_it, 0::numeric) AS tx_icms_it,
    COALESCE(trib_taxas.tipo_imposto, 0::numeric) AS tipo_imposto,
    COALESCE(trib_taxas.vlr_tot_base, 0::numeric) AS vlr_tot_base,
    COALESCE(trib_taxas.vlr_tot_base_iss, 0::numeric) AS vlr_tot_base_iss,
    COALESCE(sum(temp.vlr_to_issqn), 0::numeric) AS vlr_to_issqn,
    COALESCE(trib.vlr_subst_trib_iss, 0::numeric) AS vlr_subst_trib_iss,
    COALESCE(trib.vlr_isentas_iss, 0::numeric) AS vlr_isentas_iss,
    COALESCE(trib.vlr_n_incidencia_iss, 0::numeric) AS vlr_n_incidencia_iss,
    COALESCE(trib.vlr_base_calc_icms_iss, 0::numeric) AS vlr_base_calc_icms_iss,
    COALESCE(trib.vlr_imposto_iss::double precision, 0::double precision) AS vlr_imposto_iss,
	COALESCE(sum(temp.vlr_vd_bruta), 0::numeric) AS vlr_vd_bruta,
	COALESCE(sum(temp.vlr_fecop), 0::numeric) AS vlr_fecop,
    COALESCE(sum(temp.vlr_fecop_st), 0::numeric) AS vlr_fecop_st,
	COALESCE(sum(temp.vlr_fecop_ret), 0::numeric) AS vlr_fecop_ret,
	COALESCE(sum(temp.perc_fecop_st), 0::numeric) AS perc_fecop_st,
	COALESCE(sum(temp.perc_fecop_ret), 0::numeric) AS perc_fecop_ret,
	COALESCE(sum(temp.vlr_base_calc), 0::numeric) AS vlr_base_calc,
	COALESCE(sum(temp.vlr_icms), 0::numeric) AS vlr_icms,
	COALESCE(sum(temp.vlr_base_subst), 0::numeric) AS vlr_base_subst,
    COALESCE(sum(temp.vlr_isento), 0::numeric) AS vlr_isento,
	COALESCE(sum(temp.vlr_outras), 0::numeric) AS vlr_outras,
	COALESCE(sum(temp.vlr_icms_subst), 0::numeric) AS vlr_icms_subst,
	COALESCE(sum(temp.perc_icms), 0::numeric) AS perc_icms,
	COALESCE(sum(temp.perc_icms_subst), 0::numeric) AS perc_icms_subst,	
	COALESCE(sum(temp.perc_red_base_calc), 0::numeric) AS perc_red_base_calc,
	COALESCE(sum(temp.perc_red_base_calc_efet), 0::numeric) AS perc_red_base_calc_efet,
	COALESCE(sum(temp.perc_icms_efet), 0::numeric) AS perc_icms_efet,
	COALESCE(sum(temp.perc_icms_ret), 0::numeric) AS perc_icms_ret,
	COALESCE(sum(temp.perc_st), 0::numeric) AS perc_st,
	COALESCE(sum(temp.vlr_base_calc_efet), 0::numeric) AS vlr_base_calc_efet,
	COALESCE(sum(temp.vlr_icms_efet), 0::numeric) AS vlr_icms_efet,
	COALESCE(sum(temp.vlr_base_calc_ret), 0::numeric) AS vlr_base_calc_ret,
	COALESCE(sum(temp.vlr_icms_ret), 0::numeric) AS vlr_icms_ret
	
   FROM ( SELECT c.cd_emp,
            c.cd_filial,
            c.cd_cx,
            c.cd_vd AS cd_ctr,
            c.dt_vd AS dt_cupom,
            c.nr_ecf AS coo,
            c.vlr_desc AS vl_desc_vd,
            ( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp 
				    AND c.cd_filial = it.cd_filial 
					AND c.cd_vd = it.cd_vd 
					AND it.tipo_imposto = 0::numeric 
					AND it.st_it = 1::numeric 
					AND c.st_vd = 0::numeric) AS vlr_contab,
            ( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric AND c.st_vd = 0::numeric) AS vlr_vd_liq,
            ( SELECT COALESCE(sum(it.vlr_tot_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 2::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 0::numeric) AS vlr_it_cancel,
            ( SELECT COALESCE(sum(it.vlr_tot_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 2::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 1::numeric) AS vlr_it_cancel_issqn,
            ( SELECT COALESCE(sum(it.vlr_it * it.qt_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND c.st_vd = 1::numeric AND it.tipo_imposto = 0::numeric) AS vlr_cupons_cancelados,
            ( SELECT COALESCE(sum(it.vlr_it * it.qt_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND c.st_vd = 1::numeric AND it.tipo_imposto = 1::numeric) AS vlr_cupons_cancelados_issqn,
            ( SELECT COALESCE(sum(it.vlr_desc_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric) AS vlr_desc_it,
            ( SELECT COALESCE(sum(it.vlr_desc_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 1::numeric) AS vlr_desc_it_issqn,
            ( SELECT COALESCE(sum(it.vlr_liq_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 1::numeric) AS vlr_to_issqn,
            ( SELECT COALESCE(sum(it.vlr_liq_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric) AS vlr_liq_it,
        
		    ( SELECT COALESCE(sum(it.vlr_it * it.qt_it), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_vd_bruta,
	   
 	   ( SELECT COALESCE(sum(it.vlr_fecop), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_fecop,
		
	   ( SELECT COALESCE(sum(it.vlr_fecop_st), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_fecop_st,	

	   ( SELECT COALESCE(sum(it.vlr_fecop_ret), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_fecop_ret,		 

	   ( SELECT COALESCE(sum(it.perc_fecop_st), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_fecop_st, 						  
			 

	   ( SELECT COALESCE(sum(it.perc_fecop_ret), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_fecop_ret,					  
		
	   ( SELECT COALESCE(sum(it.vlr_base_calc), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_base_calc,	

	   ( SELECT COALESCE(sum(it.vlr_icms), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_icms,
				  
       ( SELECT COALESCE(sum(it.vlr_base_subst), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_base_subst,		

       ( SELECT COALESCE(sum(it.vlr_isento), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_isento,							  
				  			  		  		  		  				  
		
       ( SELECT COALESCE(sum(it.vlr_outras), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_outras,

       ( SELECT COALESCE(sum(it.vlr_icms_subst), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_icms_subst,						  
				  			  		  		  		  				  		  		  		  		  
	
       ( SELECT COALESCE(sum(it.perc_icms), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_icms,	

       ( SELECT COALESCE(sum(it.perc_icms_subst), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_icms_subst,	

       ( SELECT COALESCE(sum(it.perc_red_base_calc), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_red_base_calc,	

       ( SELECT COALESCE(sum(it.perc_red_base_calc_efet), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_red_base_calc_efet,

       ( SELECT COALESCE(sum(it.perc_icms_efet), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_icms_efet,	
				  
       ( SELECT COALESCE(sum(it.perc_icms_ret), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_icms_ret,

       ( SELECT COALESCE(sum(it.perc_st), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as perc_st,

       ( SELECT COALESCE(sum(it.vlr_base_calc_efet), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_base_calc_efet,					  
				  			  		  		  		  				  		  		  		  		  							

       ( SELECT COALESCE(sum(it.vlr_icms_efet), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_icms_efet,	
	

       ( SELECT COALESCE(sum(it.vlr_base_calc_ret), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_base_calc_ret,							  
				  			  		  		  		  				  		  		  		  		  											  
		
       ( SELECT COALESCE(sum(it.vlr_icms_ret), 0::numeric) AS "coalesce"
                   FROM pdv_vd_it it
                  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_icms_ret 					  			  		  		  		  				  		  		  		  		  																								  
				  								
           FROM pdv_vd c
          ORDER BY c.cd_emp, c.cd_filial, c.cd_cx, c.dt_vd) temp
     LEFT JOIN v_pdv_cupom_tributos trib ON temp.cd_emp = trib.cd_emp AND temp.cd_filial = trib.cd_filial AND temp.cd_cx = trib.cd_cx AND temp.dt_cupom = trib.dt_cupom
     LEFT JOIN pdv_pos_diaria_ecf pos_ecf ON temp.cd_emp = pos_ecf.cd_emp AND temp.cd_filial = pos_ecf.cd_filial AND temp.cd_cx = pos_ecf.cd_cx AND temp.dt_cupom = pos_ecf.dt_mov
     LEFT JOIN v_pdv_cupom_tributos_taxas trib_taxas ON temp.cd_emp = trib_taxas.cd_emp AND temp.cd_filial = trib_taxas.cd_filial AND temp.cd_cx = trib_taxas.cd_cx AND temp.dt_cupom = trib_taxas.dt_cupom
  GROUP BY temp.cd_emp, temp.cd_filial, temp.cd_cx, temp.dt_cupom, pos_ecf.cont_reducao_z, pos_ecf.cont_reinicio_op, pos_ecf.vl_gt_ini, pos_ecf.vl_gt_fin, trib.vlr_subst_trib, trib.vlr_isentas, trib_taxas.vlr_tot_base_iss, trib.vlr_n_incidencia, trib.vlr_base_calc_icms, trib.vlr_imposto, trib.vlr_subst_trib_iss, trib.vlr_isentas_iss, trib.vlr_n_incidencia_iss, trib.vlr_base_calc_icms_iss, trib.vlr_imposto_iss, trib_taxas.tx_icms_it, trib_taxas.tipo_imposto, trib_taxas.vlr_tot_base;


-- public.v_pdv_cupom_tef_transacao source

CREATE OR REPLACE VIEW public.v_pdv_cupom_tef_transacao
AS SELECT t.cd_emp,
    t.cd_filial,
    v.cd_cx,
    pdv_cx.id_term_tef,
    t.nsu_tef AS nsu,
    v.nr_ecf,
    t.obs,
    t.st_transacao,
    t.dt_transacao,
    t.hr_transacao,
    v.cd_vd AS cd_ctr,
    t.tipo_transacao AS pbm_transacao,
    t.retorno_tef AS retorno
   FROM pdv_vd_tef t
     JOIN pdv_vd v ON t.cd_emp = v.cd_emp AND t.cd_filial = v.cd_filial AND t.cd_vd = v.cd_vd
     JOIN pdv_cx ON t.cd_emp = pdv_cx.cd_emp AND t.cd_filial = pdv_cx.cd_filial AND v.cd_cx = pdv_cx.cd_cx;


-- public.v_pdv_vd_chqs source

CREATE OR REPLACE VIEW public.v_pdv_vd_chqs
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_vd,
    pdv_vd.cd_cx,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd.vlr_dinh,
    pdv_vd.vlr_chqs,
    pdv_vd.vlr_cartao,
    pdv_vd.vlr_tickets,
    pdv_vd.vlr_dup,
    pdv_vd.vlr_conv,
    pdv_vd.vlr_troco_chq,
    pdv_vd.vl_chqs_a_vista,
    pdv_vd.vl_chqs_a_prz,
    pdv_vd_chqs.nr_ord,
    pdv_vd_chqs.nr_chq,
    pdv_vd_chqs.sr_chq,
    pdv_vd_chqs.ano_chq,
    pdv_vd_chqs.vl_chq,
    pdv_vd_chqs.dt_emi,
    pdv_vd_chqs.dt_vencto,
    pdv_vd_chqs.cd_bc_chq,
    pdv_vd_chqs.ag_chq,
    pdv_vd_chqs.cpf_cgc_emi,
    pdv_vd_chqs.nm_emi,
    pdv_vd_chqs.fone_emi,
    pdv_vd_chqs.nr_cnt_chq,
    pdv_vd_chqs.vinc,
    pdv_vd_chqs.aut_chq,
    pdv_vd_chqs.comp_chq,
    pdv_vd_chqs.c1_chq,
    pdv_vd_chqs.c2_chq,
    pdv_vd_chqs.cmc7_chq,
    pdv_vd_chqs.mes_ano_cnt_chq,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd,
    pdv_vd_chqs
  WHERE pdv_vd.cd_emp = pdv_vd_chqs.cd_emp AND pdv_vd.cd_filial = pdv_vd_chqs.cd_filial AND pdv_vd.cd_vd = pdv_vd_chqs.cd_vd AND pdv_vd.st_vd = 0::numeric;


-- public.v_pdv_vd_cred source

CREATE OR REPLACE VIEW public.v_pdv_vd_cred
AS SELECT a.cd_emp,
    a.cd_filial,
    a.cd_vd,
    a.cd_cx,
    a.cd_cli,
    a.nr_ecf,
    a.dt_vd,
    a.vlr_cartao,
    b.cd_parc,
    b.dt_parc,
    b.vl_parc,
    a.qt_parc_cred,
    b.nr_fatura,
    a.cd_usu,
    COALESCE(a.flag_consolidado, 0) AS flag_consolidado,
    a.st_vd,
    ( SELECT
                CASE a.st_vd
                    WHEN 0 THEN 0
                    WHEN 1 THEN 2
                    ELSE NULL::integer
                END AS "case") AS sts_lanc_cred,
    a.nm_comprador,
    d.cd_mdl_vd,
    d.rz_cli,
    d.cgc_cpf,
    f.qt_parc,
    COALESCE(e.ds_mdl_vd, ''::character varying, e.ds_mdl_vd) AS ds_mdl_vd,
    e.tp_impressao,
    e.msg_venda_crediario
   FROM pdv_vd a
     JOIN pdv_vd_cred b ON a.cd_emp = b.cd_emp AND a.cd_filial = b.cd_filial AND a.cd_vd = b.cd_vd
     JOIN rc_cli_crediario d ON d.cd_cli = a.cd_cli
     LEFT JOIN rc_mdl_venda e ON d.cd_mdl_vd = e.cd_mdl_vd
     JOIN pdv_vd_tef f ON a.cd_emp = f.cd_emp AND a.cd_filial = f.cd_filial AND a.cd_vd = f.cd_vd AND f.tipo_transacao = 3::numeric
  ORDER BY b.cd_parc;


-- public.v_pdv_vd_est_nf_ent source

CREATE OR REPLACE VIEW public.v_pdv_vd_est_nf_ent
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.nr_ecf,
    pdv_vd_est_nf_ent.cd_nf,
    pdv_vd.dt_vd,
    pdv_vd.cd_cx,
    pdv_vd_est_nf_ent.ctr_conv,
    pdv_vd_est_nf_ent.ctr_tef,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd_est_nf_ent,
    pdv_vd
  WHERE pdv_vd_est_nf_ent.cd_emp = pdv_vd.cd_emp AND pdv_vd_est_nf_ent.cd_filial = pdv_vd.cd_filial AND pdv_vd_est_nf_ent.cd_vd = pdv_vd.cd_vd;


-- public.v_pdv_vd_est_nf_sai source

CREATE OR REPLACE VIEW public.v_pdv_vd_est_nf_sai
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.nr_ecf,
    pdv_vd_est_nf_sai.cd_nf,
    pdv_vd.dt_vd,
    pdv_vd.cd_cx,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd_est_nf_sai
     JOIN pdv_vd ON pdv_vd_est_nf_sai.cd_emp = pdv_vd.cd_emp AND pdv_vd_est_nf_sai.cd_filial = pdv_vd.cd_filial AND pdv_vd_est_nf_sai.cd_vd = pdv_vd.cd_vd;


-- public.v_pdv_vd_it source

CREATE OR REPLACE VIEW public.v_pdv_vd_it
AS SELECT DISTINCT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_vd,
    pdv_vd.cd_cx,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd.st_vd,
    pdv_vd_it.cd_it,
    pdv_vd_it.cd_prod,
    pdv_vd_it.qt_it,
    pdv_vd_it.qt_est_ant,
    pdv_vd_it.vlr_it,
    pdv_vd_it.tx_desc,
    pdv_vd_it.st_it,
    pdv_vd_it.cd_vend,
    pdv_vd_it.vlr_pmz,
    pdv_vd_it.vlr_custo,
    pdv_vd_it.perc_aplic,
    pdv_vd_it.vlr_desc_tot_rat,
    pdv_vd_it.vlr_liq_it AS tot_it,
    pdv_vd_it.cd_trib_fc,
    pdv_vd_it.tx_icms_it,
    pdv_vd_it.tx_red_it,
    pdv_vd_it.cd_medico_rec,
    COALESCE(pdv_vd_it.nr_autorizacao_pbm, '0'::character varying) AS nr_orc_vd_link,
    pdv_vd_it.vlr_unit_pbm AS vlr_unit_farm,
    pdv_vd_it.vlr_avista_pbm AS vlr_prod_cli,
    pdv_vd_it.vlr_reembol,
    pdv_vd_it.vlr_conv_pbm AS vlr_convenio,
    pdv_vd_it.cnpj_conv,
    pdv_vd_it.qtde_ponto_fidel,
    pdv_vd_it.envio_fidel,
    pdv_vd_it.tipo_desconto,
    COALESCE(pdv_vd_it.vlr_desc_verba) AS vlr_desc_verba,
    COALESCE(pdv_vd_it.perc_desc_verba) AS perc_desc_verba,
    pdv_vd_it.qt_aut_pbm,
    pdv_vd_it.vd_operador,
    COALESCE(pdv_vd_it.cd_vend_verba) AS cd_vend_verba,
    pdv_vd.vd_troca_fidel,
    pdv_vd_it.cd_grp_comis_pdv,
    pdv_vd_it.libera_vd_conv,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado,
    COALESCE(pdv_vd.cd_cli_pbm, 0::numeric) AS cd_cli_pbm,
    pdv_vd_it.cd_usu_cancel,
    COALESCE(pdv_vd_it.nr_protocolo_manipulado, ''::character varying) AS nr_protocolo_manipulado,
    pdv_vd_it.tipo_imposto,
    pdv_vd_it.vlr_imposto_it,
    pdv_vd_it.tx_imposto_it,
    pdv_vd_it.cd_prod_kit,
    pdv_vd_it.qt_it_kit
   FROM pdv_vd
     JOIN pdv_vd_it ON pdv_vd.cd_emp = pdv_vd_it.cd_emp AND pdv_vd.cd_filial = pdv_vd_it.cd_filial AND pdv_vd.cd_vd = pdv_vd_it.cd_vd;


-- public.v_pdv_vd_it_rec source

CREATE OR REPLACE VIEW public.v_pdv_vd_it_rec
AS SELECT DISTINCT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_cx,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd.st_vd,
    pdv_vd_it.cd_it,
    pdv_vd_it.cd_prod,
    pdv_vd_it.qt_it,
    COALESCE(est_orc_glb_medico.cd_medico_rec::numeric, pdv_vd_it.cd_medico_rec) AS cd_medico_rec,
    pdv_vd.flag_consolidado
   FROM pdv_vd
     JOIN pdv_vd_it ON pdv_vd.cd_emp = pdv_vd_it.cd_emp AND pdv_vd.cd_filial = pdv_vd_it.cd_filial AND pdv_vd.cd_vd = pdv_vd_it.cd_vd
     LEFT JOIN pdv_vd_orc ON pdv_vd_it.cd_emp = pdv_vd_orc.cd_emp AND pdv_vd_it.cd_filial = pdv_vd_orc.cd_filial AND pdv_vd_it.cd_vd = pdv_vd_orc.cd_vd
     LEFT JOIN est_orc_glb_medico ON pdv_vd_orc.cd_emp = est_orc_glb_medico.cd_emp::numeric AND pdv_vd_orc.cd_filial = est_orc_glb_medico.cd_filial::numeric AND pdv_vd_orc.cd_orc = est_orc_glb_medico.nr_orc::numeric
  ORDER BY pdv_vd.cd_emp, pdv_vd.cd_filial, pdv_vd.cd_cx, pdv_vd.nr_ecf, pdv_vd.dt_vd, pdv_vd.st_vd, pdv_vd_it.cd_it, pdv_vd_it.cd_prod, pdv_vd_it.qt_it, (COALESCE(est_orc_glb_medico.cd_medico_rec::numeric, pdv_vd_it.cd_medico_rec));


-- public.v_pdv_vd_orc source

CREATE OR REPLACE VIEW public.v_pdv_vd_orc
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_vd,
    pdv_vd.cd_cx,
    pdv_vd.cd_cli,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd.vlr_cartao,
    pdv_vd_orc.cd_orc,
    pdv_vd_orc.tp_orc_entg,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd,
    pdv_vd_orc
  WHERE pdv_vd.cd_emp = pdv_vd_orc.cd_emp AND pdv_vd.cd_filial = pdv_vd_orc.cd_filial AND pdv_vd.cd_vd = pdv_vd_orc.cd_vd;


-- public.v_pdv_vd_tef source

CREATE OR REPLACE VIEW public.v_pdv_vd_tef
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_vd,
    pdv_vd.cd_cx,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd_tef.cd_trn_tef,
    pdv_vd_tef.cd_adm_cartao,
    pdv_vd_tef.nr_autorizacao,
    pdv_vd_tef.cod_rede,
    pdv_vd_tef.cod_modalidade,
    pdv_vd_tef.cod_bandeira,
    pdv_vd_tef.vl_cartao,
    pdv_vd_tef.nsu_tef AS nsu_sitef,
    pdv_vd_tef.vl_saque_cartao,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado,
    pdv_vd_tef.tp_adm
   FROM pdv_vd,
    pdv_vd_tef
  WHERE pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd;


-- public.v_teste_pdv_vd source

CREATE OR REPLACE VIEW public.v_teste_pdv_vd
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_vd,
    pdv_vd.nr_orc,
    pdv_vd.nr_ped_televd,
    pdv_vd.orig_orc,
    pdv_vd.cd_cli,
    pdv_vd.cd_conv,
    pdv_vd.cgc_cpf,
    pdv_vd.dt_vd,
    pdv_vd.hr_vd,
    pdv_vd.cd_cx,
    pdv_vd.nr_ecf,
    pdv_vd.st_vd,
    pdv_vd.vs_pdv,
    pdv_vd.vs_pdv_rc,
    pdv_vd.vlr_vd,
    pdv_vd.vlr_liq_vd,
    pdv_vd.vlr_tot_prod,
    pdv_vd.vlr_desc,
    pdv_vd.vlr_desc_itens,
    pdv_vd.vlr_dinh,
    pdv_vd.vlr_chqs,
    pdv_vd.vlr_cartao,
    pdv_vd.vlr_tickets,
    pdv_vd.vlr_dup,
    pdv_vd.vlr_conv,
    pdv_vd.vlr_conv_pbm,
    pdv_vd.vlr_ncc,
    pdv_vd.vl_chqs_a_vista,
    pdv_vd.vl_chqs_a_prz,
    pdv_vd.cd_cli_pbm,
    pdv_vd.cd_usu AS cd_usu_ope,
    pdv_vd.cd_usu,
    pdv_vd.nm_comprador,
    pdv_vd.dados_adicionais,
    pdv_vd.cd_oper_cel AS nr_oper_cel,
    pdv_vd.nr_cel_recarga,
    pdv_vd.vlr_recarga_cel,
    pdv_vd.cd_usu_cancel,
    pdv_vd.st_canc_paf,
    ''::text AS vs_consolidador,
    pdv_vd.cd_mov,
    pdv_vd.cont_cupom_fisc,
    pdv_vd.vlr_imposto AS valor_ibpt,
    pdv_vd.tx_med_imposto AS perc_ibpt,
    pdv_vd.vlr_troco_chq,
    pdv_vd.cd_mt_cancel,
    ''::text AS obs,
    pdv_vd.flag_nfce,
    0 AS vlr_crediario,
    pdv_vd.reg_alterado,
    pdv_vd.flag_consolidado
   FROM pdv_vd;


-- public.v_teste_pdv_vd_nfce source

CREATE OR REPLACE VIEW public.v_teste_pdv_vd_nfce
AS SELECT est_nfce_env.cd_emp,
    est_nfce_env.cd_filial,
    pdv_vd.cd_vd,
    est_nfce_env.cd_nf,
    est_nfce_env.xml_nfce,
    est_nfce_env.chv_nfce,
    est_nfce_env.aut_nfce,
    est_nfce_env.sts_pend,
    est_nfce_env.ds_motivo,
    est_nfce_env.aut_nfce AS nr_prot,
    'ITEC_PDV_2.0.32.22'::text AS ver_aplic,
    'MnKugW+5nLKy3l9LNegJDDOnelk='::text AS dig_val,
    pdv_vd.flag_consolidado
   FROM est_nfce_env
     JOIN pdv_vd ON est_nfce_env.cd_emp::numeric = pdv_vd.cd_emp AND est_nfce_env.cd_filial::numeric = pdv_vd.cd_filial AND est_nfce_env.cd_nf_serie::text = pdv_vd.cd_nf_serie::text AND est_nfce_env.cd_nf::numeric = pdv_vd.nr_ecf;
 